/*:ja
 * @plugindesc (v.1.3) 特定の場面でコモンイベントを実行します。
 * @url http://galvs-scripts.com
 * @target MZ
 * @author Galv
 * 
 * @help
 * 翻訳:ムノクラ
 * https://fungamemake.com/
 * https://twitter.com/munokura/
 * 
 * 元プラグイン:
 * https://galvs-scripts.com/2020/10/21/mz-auto-common-events/
 * 
 *   Galv's Auto Common Events MZ
 * ----------------------------------------------------------------------------
 * ゲーム処理の特定の場面でコモンイベントを呼び出します。
 * プラグインの設定でコモンイベントを追加できる場所を確認し、
 * それぞれにコモンイベントIDを指定します。
 * 
 * コモンイベントの条件分岐を使用して、ゲーム中に変更するか、
 * または、利用可能なスクリプトを使用して、
 * 場面毎に新しいコモンイベントIDを指定します。
 * 
 * ----------------------------------------------------------------------------
 * 備考:
 * 
 * コモンイベントは、現在のイベントがコマンドを終了した後に実行します。
 * また、複数のコモンイベントがキューに入っている場合は、交代で実行します。
 * これらのイベントは、マップシーンか戦闘シーンでしか実行できません
 * （デフォルトでは）。
 * 
 * ----------------------------------------------------------------------------
 * 注意:
 * 
 * ゲームオーバー時のコモンイベントについてです。
 * ゲームオーバー画面を表示するには、
 * コモンイベントにゲームオーバーイベントを手動で作る必要があります。
 * パーティのアクターが全員戦闘不能の場合、イベントは実行を続けるので、
 * ゲームを続行したい場合、少なくとも1人は復活させる必要があります。
 *
 * ムノクラ追記
 * 通常のイベントコマンドで ゲームオーバーにした場合、
 * このコモンイベントは呼ばれません。
 * パーティ全員が戦闘不能になった時に実行します。
 * 
 * ----------------------------------------------------------------------------
 *  スクリプト
 * ----------------------------------------------------------------------------
 * スクリプトを利用して、ゲーム中にコモンイベントIDを変更することができます。
 * 
 *     Galv.ACE.id(x,'type');
 *        // x は使用する新しいコモンイベント ID です。
 *        // 'type' はどのコモンイベントを変更するかを指定します。
 * 
 * TYPES
 * ---------
 * 'loadFile'
 * // Load Common Event - セーブファイルが読み込まれた後に実行
 * 'saveFile'
 * // Save Common Event - 保存ファイルが作成された後に実行
 * 'mapStart'
 * // Map Start Common Event - 新しいマップに到達した後に実行
 * 'mapLoad'
 * // Map Load Common Event - メニューの開閉を含むマップの読み込み後に実行
 * 'battleLoad'
 * // Battle Load Common Event - 戦闘ロード後に実行
 * 'enterVehicle'
 * // 乗り物に乗った後に実行
 * 'exitVehicle'
 * // 乗り物を降りた後に実行
 * 'gameOver'
 * // パーティ全員が戦闘不能になった後に実行
 * 'timerEnd'
 * // デフォルトタイマーが0になった後に実行
 * 
 * 
 * @param loadFile
 * @text ロード後コモン
 * @desc セーブしたゲームが読み込まれた後に実行されるコモンイベントID
 * @default 0
 * @type common_event
 * 
 * @param saveFile
 * @text セーブ後コモン
 * @desc プレイヤーがゲームをセーブした後に実行されるコモンイベントID
 * @default 0
 * @type common_event
 * 
 * @param mapStart
 * @text マップ開始後コモン
 * @desc 新しいマップに到達した後に実行されるコモンイベントID(例:プレイヤーが新しいマップに移動する)
 * @default 0
 * @type common_event
 * 
 * @param mapLoad
 * @text マップロード後コモン
 * @desc マップシーンがロードされた後に実行されるコモンイベントID(例:メニューやシーンの表示と退出)
 * @default 0
 * @type common_event
 * 
 * @param battleLoad
 * @text 戦闘ロード後コモン
 * @desc 戦闘シーンの読み込み時に実行されるコモンイベントID
 * @default 0
 * @type common_event
 * 
 * @param enterVehicle
 * @text 乗船後コモン
 * @desc 乗り物に乗った後に実行されるコモンイベントID
 * @default 0
 * @type common_event
 * 
 * @param exitVehicle
 * @text 降船後コモン
 * @desc 乗り物を降りた後に実行されるコモンイベントID
 * @default 0
 * @type common_event
 * 
 * @param gameOver
 * @text ゲームオーバーコモン
 * @desc ゲームオーバー画面の時に実行されるコモンイベントID
 * @default 0
 * @type common_event
 * 
 * @param timerEnd
 * @text ターマー終了コモン
 * @desc タイマー終了時に実行されるコモンイベントID
 * @default 0
 * @type common_event
 */
